package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duiba.boot.event.FinalContextRefreshedEvent;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

/**
 * 用于发送MainContextRefreshedEvent事件
 */
public class FinalContextRefreshedEventPublishApplicationRunner implements ApplicationRunner, ApplicationContextAware, Ordered {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        applicationContext.publishEvent(new FinalContextRefreshedEvent(applicationContext));
    }

    /**
     * 注意这个order在DuibaEurekaAutoServiceRegistration的order之前，只有初始化完成以后才注册到eureka上
     *
     * @return
     */
    @Override
    public int getOrder() {
        return -1;
    }
}
