package cn.com.duibaboot.ext.autoconfigure.monitor.rpc.endpoint;

import cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan.RpcProviderScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import java.util.Set;

/**
 * 拉取service服务所有RPC接口 Endpoint
 */
@Endpoint(id = "rpc-provider")
public class RpcProviderEndpoint {

    private static final Logger LOGGER = LoggerFactory.getLogger(RpcProviderEndpoint.class);

    /**
     * 获取当前服务rpc接口信息
     *
     * @return
     */
    @ReadOperation
    public Set<String> invoke() {
        return RpcProviderScan.getRpcMonitorInfo();
    }

}
