/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientMethodInterceptor;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpUriRequest;

class CatHttpClientMethodInterceptor
implements HttpClientMethodInterceptor {
    CatHttpClientMethodInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String host;
        if (!"execute".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArguments();
        HttpUriRequest httpUriRequest = null;
        HttpHost httpHost = null;
        for (Object arg : args) {
            if (arg instanceof HttpUriRequest) {
                httpUriRequest = (HttpUriRequest)arg;
                break;
            }
            if (!(arg instanceof HttpHost)) continue;
            httpHost = (HttpHost)arg;
            break;
        }
        if (httpUriRequest != null) {
            host = httpUriRequest.getURI().getHost();
        } else if (httpHost != null) {
            host = httpHost.getHostName();
        } else {
            return invocation.proceed();
        }
        if (!CatUtils.isCatEnabled()) {
            return invocation.proceed();
        }
        Transaction transaction = Cat.newTransaction((String)"HttpClient", (String)host);
        try {
            Object object = invocation.proceed();
            return object;
        }
        catch (Throwable e) {
            ((DefaultTransaction)transaction).setName(host + "(failed)");
            throw e;
        }
        finally {
            transaction.setStatus("0");
            transaction.complete();
        }
    }

    public int getOrder() {
        return -1;
    }
}

