/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class CatSpringDataElasticSearchPlugin {
    private static final String space = "Elasticsearch";

    @Around(value="execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*(..))")
    public Object springDataElasticSearchJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        return CatUtils.executeInCatTransaction(() -> joinPoint.proceed(), space, methodName);
    }
}

