/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceGroupFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServiceGroupFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey((HttpServletRequest)request);
        HttpServletRequest req = (HttpServletRequest)request;
        if (groupKey == null && SpringEnvironmentUtils.isDevEnv()) {
            String ip = RequestTool.getIpAddr((HttpServletRequest)req);
            if (ip.equals("127.0.0.1")) {
                ip = NetUtils.getLocalIp();
            }
            groupKey = "dev_ip_" + ip;
        }
        if (StringUtils.isNotBlank((CharSequence)groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            ServiceGroupContext.removeGroupKey();
        }
    }

    public void destroy() {
    }
}

