/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class JvmAlertComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(JvmAlertComponent.class);
    @Value(value="${spring.application.name}")
    private String currentAppName;
    private final RestTemplate loadBalancedRestTemplate;

    public JvmAlertComponent(RestTemplate loadBalancedRestTemplate) {
        this.loadBalancedRestTemplate = loadBalancedRestTemplate;
    }

    public void doGcAlert(int ruleMinutes, String ruleValue, String currentValue, String msg) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appName", this.currentAppName);
        paramMap.put("ip", NetUtils.getLocalIp());
        paramMap.put("ruleMinutes", ruleMinutes);
        paramMap.put("ruleValue", ruleValue);
        paramMap.put("currentValue", currentValue);
        paramMap.put("msg", msg);
        paramMap.put("currentTime", DateUtils.getSecondStr((long)System.currentTimeMillis()));
        try {
            LOGGER.warn("[jvm\u544a\u8b66: {}], \u6700\u8fd1\u7684{}\u5206\u949f\u5185\uff0c\u53d1\u751f: {}, \u5927\u4e8e\u9608\u503c: {}", new Object[]{msg, ruleMinutes, currentValue, ruleValue});
            this.loadBalancedRestTemplate.postForObject("http://prism/prism/jvmAlert/gcAlert", paramMap, String.class, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("GC\u544a\u8b66\u5f02\u5e38, {}", (Object)e.getMessage());
        }
    }

    public void doThreadpoolExhaustedReport(String threadPoolName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appName", this.currentAppName);
        paramMap.put("ip", NetUtils.getLocalIp());
        paramMap.put("threadPoolName", threadPoolName);
        try {
            LOGGER.warn("[\u7ebf\u7a0b\u6c60 {} \u8017\u5c3d], \u8fdb\u884c\u4e0a\u62a5", (Object)threadPoolName);
            this.loadBalancedRestTemplate.postForObject("http://prism/prism/jvmAlert/threadpoolExhaustedReport", paramMap, String.class, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u7ebf\u7a0b\u6c60\u8017\u5c3d\u4e0a\u62a5\u5f02\u5e38, {}", (Object)e.getMessage());
        }
    }
}

