/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duibaboot.ext.autoconfigure.web.BootMonitorCheckFilter;
import cn.com.duibaboot.ext.autoconfigure.web.BootMonitorCheckReactiveFilter;
import cn.com.duibaboot.ext.autoconfigure.web.ClientAbortExceptionIgnoreFilter;
import cn.com.duibaboot.ext.autoconfigure.web.DBTimeProfileFilter;
import cn.com.duibaboot.ext.autoconfigure.web.FeatureFilter;
import cn.com.duibaboot.ext.autoconfigure.web.FeatureReactiveFilter;
import cn.com.duibaboot.ext.autoconfigure.web.ServiceReadyFilter;
import cn.com.duibaboot.ext.autoconfigure.web.cookie.Rfc2109CookieFixFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.server.WebFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcMonitorAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class BootMonitorCheckFilterConfigurationReactive {
        @Bean
        public WebFilter bootMonitorCheckFilterConfigurer() {
            return new BootMonitorCheckReactiveFilter();
        }

        @Bean
        public WebFilter featureFilter() {
            return new FeatureReactiveFilter();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class BootMonitorCheckFilterConfigurationServlet {
        @Resource
        private List<FilterRegistrationBean> filters;
        @Value(value="${duiba.warmup.timemillis:300000}")
        private Integer duibaWarmUpTimeMillis;

        @PostConstruct
        public void init() {
            for (FilterRegistrationBean filter : this.filters) {
                if (filter.getOrder() != Integer.MIN_VALUE) continue;
                throw new IllegalStateException("filter:[" + filter.getFilter().getClass().getName() + "] 's order is too small, must bigger than Integer.MIN_VALUE(the order of OrderedCharacterEncodingFilter), if not, there will be chinese garbled");
            }
        }

        @Bean
        public FilterRegistrationBean bootMonitorCheckFilterConfigurer() {
            BootMonitorCheckFilter filter = new BootMonitorCheckFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/monitor/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483647);
            return registrationBean;
        }

        @Bean
        public FilterRegistrationBean serviceReadyFilterConfigurer() {
            ServiceReadyFilter filter = new ServiceReadyFilter(this.duibaWarmUpTimeMillis);
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/isReady");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483647);
            return registrationBean;
        }

        @Bean
        public FilterRegistrationBean dbTimeProfileFilterConfigurer() {
            DBTimeProfileFilter filter = new DBTimeProfileFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)filter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-1);
            return registrationBean;
        }

        @Bean
        public Filter featureFilter() {
            return new FeatureFilter();
        }

        @Configuration
        @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class, ClientAbortException.class})
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        public static class ClientAbortExceptionIgnoreFilterConfiguration {
            @Bean
            public FilterRegistrationBean clientAbortExceptionIgnoreFilterConfigurer() {
                ClientAbortExceptionIgnoreFilter filter = new ClientAbortExceptionIgnoreFilter();
                FilterRegistrationBean registrationBean = new FilterRegistrationBean();
                registrationBean.setFilter((Filter)filter);
                ArrayList<String> urlPatterns = new ArrayList<String>();
                urlPatterns.add("/*");
                registrationBean.setUrlPatterns(urlPatterns);
                registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
                registrationBean.setOrder(2);
                return registrationBean;
            }
        }

        @Configuration
        @ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class, Request.class})
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        public static class Rfc2019CookieFilterConfiguration {
            @Bean
            public FilterRegistrationBean rfc2019CookieFilterConfigurer() {
                Rfc2109CookieFixFilter filter = new Rfc2109CookieFixFilter();
                FilterRegistrationBean registrationBean = new FilterRegistrationBean();
                registrationBean.setFilter((Filter)filter);
                ArrayList<String> urlPatterns = new ArrayList<String>();
                urlPatterns.add("/*");
                registrationBean.setUrlPatterns(urlPatterns);
                registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
                registrationBean.setOrder(-2147483638);
                return registrationBean;
            }
        }
    }
}

