/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.csp;

import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class CspReportReactiveFilter
implements WebFilter {
    private static final Logger cspReportLogger = LoggerFactory.getLogger((String)"duibaCspReportLog");

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String uri;
        if (cspReportLogger.isInfoEnabled() && (uri = exchange.getRequest().getPath().pathWithinApplication().value()).equals("/csp/report") && exchange.getRequest().getMethod() == HttpMethod.POST) {
            return exchange.getRequest().getBody().map(dataBuffer -> dataBuffer.asByteBuffer().array()).map(bs -> new String((byte[])bs, Charset.forName("utf-8"))).doOnNext(json -> cspReportLogger.info(json)).then();
        }
        return chain.filter(exchange);
    }
}

