/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.servlet.CatFilter;
import cn.com.duiba.cat.status.ServerRefresher;
import cn.com.duiba.cat.status.StatusExtension;
import cn.com.duiba.cat.status.StatusExtensionRegister;
import cn.com.duiba.wolf.cache.XMemcacheClient;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.cat.CatApacheHbaseConnectAspect;
import cn.com.duibaboot.ext.autoconfigure.cat.CatHandlerInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cat.CatHttpAsyncClientPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.cat.CatHttpClientMethodInterceptor;
import cn.com.duibaboot.ext.autoconfigure.cat.CatJestElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatMemcachePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatMybatisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatProperties;
import cn.com.duibaboot.ext.autoconfigure.cat.CatReactiveWebFilter;
import cn.com.duibaboot.ext.autoconfigure.cat.CatRediscachePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataLettucePlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.CatSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.cat.SpringMvcConfigForCat;
import cn.com.duibaboot.ext.autoconfigure.cat.annotation.CatTransactionAspect;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatInstance;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaInstanceChangedEvent;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.netflix.discovery.EurekaClient;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.searchbox.client.JestClient;
import io.undertow.Undertow;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rubyeye.xmemcached.MemcachedClient;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.server.WebFilter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.xnio.XnioWorker;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@Import(value={SpringMvcConfigForCat.class})
@EnableConfigurationProperties(value={CatProperties.class})
public class CatAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatAutoConfiguration.class);
    public static final List<String> CAT_APP_NAMES = Arrays.asList("duiba-cat-web", "duiba-cat-consumer");
    private static final String ThreadPoolWaterLevelId = "\u7ebf\u7a0b\u6c60\u6c34\u4f4d\u56fe";
    @Resource
    private CatProperties catProperties;

    @EventListener(value={EnvironmentChangeEvent.class, MainContextRefreshedEvent.class})
    @Order(value=0x7FFFFFFF)
    public void refresh() {
        if (this.catProperties.isEnabled()) {
            CatInstance.enable();
        } else {
            CatInstance.disable();
        }
    }

    private static boolean isCat(String appName) {
        return CAT_APP_NAMES.contains(appName);
    }

    @Bean
    @Conditional(value={CatCondition.class})
    public CatTransactionAspect catTransactionAspect() {
        return new CatTransactionAspect();
    }

    public static class CatCondition
    implements Condition {
        private static volatile boolean initted = false;

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            this.checkCatInited(context.getEnvironment());
            return CatUtils.isCatEnabled();
        }

        private synchronized void checkCatInited(Environment env) {
            if (initted) {
                return;
            }
            initted = true;
            String appName = env.getProperty("spring.application.name");
            if (StringUtils.isEmpty((CharSequence)appName)) {
                LOGGER.warn("you need to set property[spring.application.name] in bootstrap.properties");
                return;
            }
            System.setProperty("cat.app.name", appName);
            String eurekaServerUrl = env.getProperty("eureka.client.service-url.defaultZone");
            if (StringUtils.isBlank((CharSequence)eurekaServerUrl)) {
                LOGGER.error("cat not found property[eureka.client.service-url.defaultZone] in env");
                return;
            }
            System.setProperty("eureka.service-url", eurekaServerUrl);
            CatUtils.isCatEnabled();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={CatFilter.class})
    public static class DubiaThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    ApplicationListener<ContextRefreshedEvent> {
        private List<ThreadPoolExecutorWrapper> threadPools;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.threadPools != null) {
                for (ThreadPoolExecutorWrapper p : this.threadPools) {
                    maps.put(p.getThreadPoolName() + "-ActiveCount(core:" + p.getCorePoolSize() + ",max:" + p.getMaximumPoolSize() + ")", String.valueOf(p.getActiveCount()));
                }
            }
            return maps;
        }

        @PostConstruct
        public void initialize() {
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ApplicationContext applicationContext = event.getApplicationContext();
            try {
                Map beansMap = applicationContext.getBeansOfType(ThreadPoolExecutorWrapper.class);
                if (beansMap != null && !beansMap.isEmpty()) {
                    this.threadPools = new ArrayList(beansMap.values());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.threadPools != null) {
                StatusExtensionRegister.getInstance().register((StatusExtension)this);
            }
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={UndertowServletWebServerFactory.class, Undertow.class, Servlet.class, CatFilter.class})
    public static class HttpThreadPoolWaterLevelHeartbeatExtenstionForUndertow
    implements StatusExtension,
    ApplicationListener<WebServerInitializedEvent> {
        private ThreadPoolExecutor httpThreadPool;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.httpThreadPool != null) {
                maps.put("Undertow-ActiveCount(core:" + this.httpThreadPool.getCorePoolSize() + ",max:" + this.httpThreadPool.getMaximumPoolSize() + ")", String.valueOf(this.httpThreadPool.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() {
        }

        public void onApplicationEvent(WebServerInitializedEvent event) {
            ThreadPoolExecutor threadPoolExecutor;
            WebServer c = event.getWebServer();
            if (!(c instanceof UndertowServletWebServer)) {
                return;
            }
            UndertowServletWebServer container = (UndertowServletWebServer)c;
            Field field = ReflectionUtils.findField(container.getClass(), (String)"undertow");
            field.setAccessible(true);
            Undertow undertow = (Undertow)ReflectionUtils.getField((Field)field, (Object)container);
            XnioWorker worker = undertow.getWorker();
            field = ReflectionUtils.findField(worker.getClass(), (String)"taskPool");
            field.setAccessible(true);
            this.httpThreadPool = threadPoolExecutor = (ThreadPoolExecutor)ReflectionUtils.getField((Field)field, (Object)worker);
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={TomcatServletWebServerFactory.class, Tomcat.class, Servlet.class, CatFilter.class})
    public static class HttpThreadPoolWaterLevelHeartbeatExtenstion
    implements StatusExtension,
    ApplicationListener<WebServerInitializedEvent> {
        private ThreadPoolExecutor httpThreadPool;

        public String getId() {
            return CatAutoConfiguration.ThreadPoolWaterLevelId;
        }

        public String getDescription() {
            return "\u5404\u4e2a\u7ebf\u7a0b\u6c60\u7684\u6c34\u4f4d\u76d1\u63a7\u5fc3\u8df3";
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> maps = new HashMap<String, String>();
            if (this.httpThreadPool != null) {
                maps.put("Tomcat-ActiveCount(core:" + this.httpThreadPool.getCorePoolSize() + ",max:" + this.httpThreadPool.getMaximumPoolSize() + ")", String.valueOf(this.httpThreadPool.getActiveCount()));
            }
            return maps;
        }

        @PostConstruct
        public void initialize() {
        }

        public void onApplicationEvent(WebServerInitializedEvent event) {
            WebServer c = event.getWebServer();
            if (!(c instanceof TomcatWebServer)) {
                return;
            }
            TomcatWebServer container = (TomcatWebServer)c;
            Executor es = container.getTomcat().getConnector().getProtocolHandler().getExecutor();
            if (!(es instanceof ThreadPoolExecutor)) {
                return;
            }
            this.httpThreadPool = (ThreadPoolExecutor)es;
            StatusExtensionRegister.getInstance().register((StatusExtension)this);
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={Cat.class, EurekaClient.class})
    @ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
    @ConditionalOnDiscoveryEnabled
    public static class EurekaInstanceChangedEventListener
    implements ApplicationListener<EurekaInstanceChangedEvent> {
        private static volatile ServerRefresher serverRefresher;

        public void onApplicationEvent(EurekaInstanceChangedEvent event) {
            Set<String> appNames = event.getAppNames();
            if (CollectionUtils.isEmpty(appNames)) {
                return;
            }
            if (appNames.contains("duiba-cat-consumer")) {
                if (serverRefresher == null) {
                    serverRefresher = new ServerRefresher();
                }
                serverRefresher.refresh();
                LOGGER.info("cat\u6d88\u8d39\u7aef\u673a\u5668\u53d8\u66f4, \u5ba2\u6237\u7aef\u6267\u884c\u5237\u65b0");
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={Cat.class})
    public static class InitCatServer
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        public void onApplicationEvent(ContextRefreshedEvent event) {
            CatInstance.isEnable();
        }

        public int getOrder() {
            return -3;
        }
    }

    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={HttpClient.class})
    @Configuration
    public static class CatHttpClientConfiguration {
        @Bean
        public CatHttpClientMethodInterceptor catHttpClientMethodInterceptor() {
            return new CatHttpClientMethodInterceptor();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnProperty(name={"duiba.hbase.zk-quorum"}, matchIfMissing=false)
    public static class CatApacheHbaseConfiguration {
        @Bean
        @ConditionalOnClass(value={Connection.class, Table.class, Aspect.class})
        public CatApacheHbaseConnectAspect catApacheHbaseConnectAspect() {
            return new CatApacheHbaseConnectAspect();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={JestClient.class, Cat.class, Aspect.class})
    public static class CatJestElasticsearchConfiguration {
        @Bean
        public CatJestElasticSearchPlugin catJestElasticSearchPlugin() {
            return new CatJestElasticSearchPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={ElasticsearchOperations.class, Cat.class, Aspect.class})
    public static class CatElasticsearchConfiguration {
        @Bean
        public CatSpringDataElasticSearchPlugin getCatSpringDataElasticSearchPlugin() {
            return new CatSpringDataElasticSearchPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={MongoOperations.class, Cat.class, Aspect.class})
    public static class CatMongodbConfiguration {
        @Bean
        public CatSpringDataMongodbPlugin getCatSpringDataMongodbPlugin() {
            return new CatSpringDataMongodbPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={XMemcacheClient.class, MemcachedClient.class, Cat.class, Aspect.class})
    public static class CatMemcacheConfiguration {
        @Bean
        public CatMemcachePlugin getCatMemcachePlugin() {
            return new CatMemcachePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, RedisClusterAsyncCommands.class, Cat.class, Aspect.class})
    @Conditional(value={CatCondition.class})
    public static class CatSpringDataLettuceAspectConfiguration {
        @Bean
        public CatSpringDataLettucePlugin catSpringDataLettuceAspectPlugin() {
            return new CatSpringDataLettucePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Cat.class, Aspect.class})
    @Conditional(value={CatCondition.class})
    public static class CatSpringDataRedisAspectConfiguration {
        @Bean
        public CatSpringDataRedisPlugin catSpringDataRedisAspectPlugin() {
            return new CatSpringDataRedisPlugin();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Cat.class, Aspect.class})
    public static class CatRediscacheConfiguration {
        @Bean
        public CatRediscachePlugin getCatCachePlugin() {
            return new CatRediscachePlugin();
        }
    }

    private static class CatMybatisBeanPostProcessor
    implements SpecifiedBeanPostProcessor<Object> {
        private CatMybatisBeanPostProcessor() {
        }

        public int getOrder() {
            return -1;
        }

        @Override
        public Class<Object> getBeanType() {
            return Object.class;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            SqlSessionFactory s = null;
            if (bean instanceof SqlSessionFactory) {
                s = (SqlSessionFactory)bean;
            }
            if (bean instanceof SqlSessionTemplate) {
                s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
            }
            if (s == null) {
                return bean;
            }
            this.addInterceptor(s);
            return bean;
        }

        private void addInterceptor(SqlSessionFactory s) {
            boolean hasCatPlugin = false;
            if (!CollectionUtils.isEmpty((Collection)s.getConfiguration().getInterceptors())) {
                for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                    if (!(plugin instanceof CatMybatisPlugin)) continue;
                    hasCatPlugin = true;
                    break;
                }
            }
            if (!hasCatPlugin) {
                s.getConfiguration().addInterceptor((Interceptor)new CatMybatisPlugin());
            }
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={CloseableHttpAsyncClient.class, Cat.class})
    public static class CatHttpAsyncClientPostProcessorConfiguration {
        @Bean
        public static SpecifiedBeanPostProcessor catHttpAsyncClientPostProcessorConfigurer() {
            return new CatHttpAsyncClientPostProcessor();
        }
    }

    @Configuration
    @Conditional(value={CatCondition.class})
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, CatMybatisPlugin.class, Cat.class})
    public static class CatMyBatisPostProcessorConfiguration {
        @Bean
        public static SpecifiedBeanPostProcessor catMyBatisPostProcessorConfigurer() {
            return new CatMybatisBeanPostProcessor();
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.route.Route"})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Conditional(value={CatCondition.class})
    public static class CatHttpHandlerInterceptorReactiveConfiguration {
        @Bean
        public WebFilter catWebFilter() {
            return new CatReactiveWebFilter();
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={CatProperties.class})
    @ConditionalOnClass(value={Servlet.class, InterceptorRegistry.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Conditional(value={CatCondition.class})
    @Order(value=-99)
    public static class CatHttpHandlerInterceptorServletConfiguration
    implements WebMvcConfigurer {
        @Resource
        private CatProperties catProperties;

        public void addInterceptors(InterceptorRegistry registry) {
            CatHandlerInterceptor chi = new CatHandlerInterceptor(this.catProperties){

                @Override
                public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                    if ("true".equals(request.getHeader("X-Rpc"))) {
                        return true;
                    }
                    return super.preHandle(request, response, handler);
                }
            };
            registry.addInterceptor((HandlerInterceptor)chi);
        }
    }
}

