/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.internal.DefaultTransaction;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.BeansException;

public class CatHttpAsyncClientPostProcessor
implements SpecifiedBeanPostProcessor<CloseableHttpAsyncClient> {
    private static final String CAT_HTTP_ASYNC_CLIENT_NAME = "HttpAsyncClient";

    @Override
    public Class<CloseableHttpAsyncClient> getBeanType() {
        return CloseableHttpAsyncClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return new CatHttpAsyncClientWrapper(bean);
    }

    public int getOrder() {
        return 0;
    }

    public static class CatHttpAsyncClientWrapper
    extends CloseableHttpAsyncClient {
        private CloseableHttpAsyncClient original;

        public CatHttpAsyncClientWrapper(CloseableHttpAsyncClient original) {
            this.original = original;
        }

        private <T> FutureCallback<T> getCatWrappedCallback(final FutureCallback<T> callback, final String hostname) {
            if (!CatUtils.isCatEnabled()) {
                return callback;
            }
            final long start = System.nanoTime();
            FutureCallback wrappedCallback = new FutureCallback<T>(){

                public void completed(T result) {
                    DefaultTransaction transaction = (DefaultTransaction)Cat.newTransaction((String)CatHttpAsyncClientPostProcessor.CAT_HTTP_ASYNC_CLIENT_NAME, (String)hostname);
                    transaction.setDurationStart(start);
                    transaction.setStatus("0");
                    transaction.complete();
                    callback.completed(result);
                }

                public void failed(Exception ex) {
                    DefaultTransaction transaction = (DefaultTransaction)Cat.newTransaction((String)CatHttpAsyncClientPostProcessor.CAT_HTTP_ASYNC_CLIENT_NAME, (String)(hostname + "(failed)"));
                    transaction.setDurationStart(start);
                    transaction.setStatus("0");
                    transaction.complete();
                    callback.failed(ex);
                }

                public void cancelled() {
                    DefaultTransaction transaction = (DefaultTransaction)Cat.newTransaction((String)CatHttpAsyncClientPostProcessor.CAT_HTTP_ASYNC_CLIENT_NAME, (String)(hostname + "(cancelled)"));
                    transaction.setDurationStart(start);
                    transaction.setStatus("0");
                    transaction.complete();
                    callback.cancelled();
                }
            };
            return wrappedCallback;
        }

        public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
            return this.original.execute(requestProducer, responseConsumer, context, this.getCatWrappedCallback(callback, this.getHostName(requestProducer)));
        }

        private String getHostName(HttpAsyncRequestProducer requestProducer) {
            String hostname = "unknown";
            HttpHost host = requestProducer.getTarget();
            if (host != null) {
                hostname = host.getHostName();
            }
            return hostname;
        }

        private String getHostName(HttpHost target, HttpRequest request) {
            String hostname = "unknown";
            if (target != null) {
                hostname = target.getHostName();
            } else if (request != null && request instanceof HttpUriRequest) {
                hostname = ((HttpUriRequest)request).getURI().getHost();
            }
            return hostname;
        }

        public boolean isRunning() {
            return this.original.isRunning();
        }

        public void start() {
            this.original.start();
        }

        public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
            return this.original.execute(requestProducer, responseConsumer, this.getCatWrappedCallback(callback, this.getHostName(requestProducer)));
        }

        public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
            return this.original.execute(target, request, context, this.getCatWrappedCallback(callback, this.getHostName(target, request)));
        }

        public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
            return this.original.execute(target, request, this.getCatWrappedCallback(callback, this.getHostName(target, request)));
        }

        public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
            return this.original.execute(request, context, this.getCatWrappedCallback(callback, this.getHostName(null, (HttpRequest)request)));
        }

        public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
            return this.original.execute(request, this.getCatWrappedCallback(callback, this.getHostName(null, (HttpRequest)request)));
        }

        public void close() throws IOException {
            this.original.close();
        }
    }
}

