/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomApacheHttpClient;
import feign.Client;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={CustomApacheHttpClient.class})
@ConditionalOnProperty(value={"feign.httpclient.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(name={"org.springframework.cloud.openfeign.ribbon.FeignRibbonClientAutoConfiguration"})
public class CustomHttpClientFeignLoadBalancedAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={Client.class})
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory, SpringClientFactory clientFactory, HttpClient httpClient) {
        CustomApacheHttpClient delegate = new CustomApacheHttpClient(httpClient);
        return new LoadBalancerFeignClient((Client)delegate, cachingFactory, clientFactory);
    }
}

