/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class DuibaRedisCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        return DuibaRedisCondition.isRedisAutoConfigEnable(environment) ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)"Can't find redis configuration in environment.");
    }

    public static boolean isRedisAutoConfigEnable(Environment environment) {
        String redisHost = environment.getProperty("duiba.redis.host");
        String redisClusterNodes = environment.getProperty("duiba.redis.cluster.nodes");
        String redisSentinelMaster = environment.getProperty("duiba.redis.sentinel.master");
        return StringUtils.isNotBlank((String)redisHost) || StringUtils.isNotBlank((String)redisClusterNodes) || StringUtils.isNotBlank((String)redisSentinelMaster);
    }
}

