/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import cn.com.duibaboot.ext.autoconfigure.web.ServerStatusHolder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class BootMonitorCheckFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath((HttpServletRequest)request);
        if (requestPath.equals("/monitor/check")) {
            if (!ServerStatusHolder.isInService()) {
                response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(ServerStatusHolder.isInService() ? "OK" : "INVALID");
        } else if (requestPath.equals("/monitor/stop")) {
            if (!HttpRequestUtils.isLocalRequest(request)) {
                response.getWriter().write("NO PERMISSION");
                return;
            }
            ServerStatusHolder.setInService(false);
            response.getWriter().write("OK");
        } else if (requestPath.equals("/monitor/start")) {
            if (!HttpRequestUtils.isLocalRequest(request)) {
                response.getWriter().write("NO PERMISSION");
                return;
            }
            ServerStatusHolder.setInService(true);
            response.getWriter().write("OK");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

