/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterBasedRule
extends ZoneAvoidanceRule {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<RibbonServerListFilter> serverListFilters;

    public FilterBasedRule(List<RibbonServerListFilter> serverListFilters) {
        if (serverListFilters != null) {
            this.serverListFilters = new ArrayList<RibbonServerListFilter>(serverListFilters);
        }
    }

    public Server choose(Object key) {
        ILoadBalancer lb = this.getLoadBalancer();
        if (lb == null) {
            this.log.warn("no load balancer");
            return null;
        }
        List servers = this.getPredicate().getEligibleServers(lb.getReachableServers(), key);
        if (this.serverListFilters != null) {
            for (RibbonServerListFilter filter : this.serverListFilters) {
                servers = filter.filter(servers, key);
            }
        }
        if (servers.isEmpty()) {
            this.log.info("No available alive server from lb.getReachableServers(), failback to lb.getAllServers()");
            servers = lb.getAllServers();
        }
        if (CollectionUtils.isEmpty((Collection)servers)) {
            return null;
        }
        return this.chooseFromServers(servers, this.getLoadBalancer(), key);
    }

    protected abstract Server chooseFromServers(List<Server> var1, ILoadBalancer var2, Object var3);

    protected int getTimeBasedWeight(Server server) {
        int weight = 100;
        if (server instanceof DiscoveryEnabledServer) {
            String weightStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("weight");
            weight = NumberUtils.parseInt((String)weightStr, (int)100);
            weight = Math.max(weight, 0);
        }
        if (weight > 0) {
            long uptime;
            long timestamp = 0L;
            int warmUpTimeMillis = 300000;
            if (server instanceof DiscoveryEnabledServer) {
                String tsStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("serverStartUpTime");
                timestamp = NumberUtils.parseLong((String)tsStr, (long)0L);
                timestamp = Math.max(timestamp, 0L);
                String wuStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duiba.warmup.timemillis");
                warmUpTimeMillis = NumberUtils.parseInt((String)wuStr, (int)300000);
                warmUpTimeMillis = Math.max(warmUpTimeMillis, 0);
            }
            if (timestamp > 0L && (uptime = System.currentTimeMillis() - timestamp) < Integer.MAX_VALUE) {
                if (uptime <= 0L) {
                    weight = 1;
                } else if (uptime < (long)warmUpTimeMillis) {
                    weight = this.calculateWarmupWeight((int)uptime, warmUpTimeMillis, weight);
                }
            }
        }
        return weight;
    }

    private int calculateWarmupWeight(int uptime, int warmup, int weight) {
        int ww = (int)Math.pow(weight, (double)uptime / (double)warmup);
        if (ww < 1) {
            return 1;
        }
        return Math.min(ww, weight);
    }
}

