/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import brave.Span;
import brave.Tracer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;

@Order(value=-2147483642)
public class DuibaTraceSecondFilter
implements Filter {
    private Pattern skipPattern = Pattern.compile("/api-docs.*|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream");
    private static ApplicationContext applicationContext;
    private static volatile Tracer tracer;

    private static Tracer getTracer() {
        if (tracer == null) {
            tracer = (Tracer)applicationContext.getBean(Tracer.class);
        }
        return tracer;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        DuibaTraceSecondFilter.applicationContext = applicationContext;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Filter just supports HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean skip = this.skipPattern.matcher(httpRequest.getRequestURI()).matches();
        if (!skip) {
            Span span = DuibaTraceSecondFilter.getTracer().currentSpan();
            String bagFlages = ExtraFieldPropagation.get((TraceContext)span.context(), (String)"X-B3-Flags");
            String flages = (String)Optional.ofNullable(servletRequest.getAttribute("X-B3-Flags")).orElse("0");
            if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)flages) || StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)bagFlages)) {
                ExtraFieldPropagation.set((TraceContext)span.context(), (String)"X-B3-Flags", (String)"1");
                response.setHeader("X-B3-TraceId", span.context().traceIdString());
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    protected static Boolean isDebugMode() {
        if (applicationContext == null) {
            return false;
        }
        if (tracer == null || tracer.currentSpan() == null) {
            return false;
        }
        Span span = tracer.currentSpan();
        String bagFlages = ExtraFieldPropagation.get((TraceContext)span.context(), (String)"X-B3-Flags");
        return StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)bagFlages);
    }
}

