/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping;

import cn.com.duibaboot.ext.autoconfigure.grouping.filter.ServiceGroupFilter;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@ConditionalOnClass(value={TransmittableThreadLocal.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class ServiceGroupAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServiceGroupFilterConfigurationServlet {
        ServiceGroupFilterConfigurationServlet() {
        }

        @Bean
        public ServiceGroupFilter serviceGroupFilter() {
            return new ServiceGroupFilter();
        }

        @Bean
        public FilterRegistrationBean<ServiceGroupFilter> serviceGroupFilterConfigurer(ServiceGroupFilter serviceGroupFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)serviceGroupFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(-2147483642);
            return registrationBean;
        }
    }
}

