/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.jvm.alert;

import cn.com.duibaboot.ext.autoconfigure.monitor.jvm.JstatPoint;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public abstract class GcAlerter {
    public abstract Map<Integer, Integer> getRule();

    public abstract int compute(Pair<JstatPoint, JstatPoint> var1);

    public abstract void alert(int var1, int var2, int var3);

    public void run(LinkedList<JstatPoint> pointQueue) {
        Map<Integer, Integer> rule = this.getRule();
        for (Map.Entry<Integer, Integer> entry : rule.entrySet()) {
            int currentValue;
            int ruleMinutes = entry.getKey();
            Pair<JstatPoint, JstatPoint> pointPair = this.getPointPair(pointQueue, ruleMinutes);
            if (pointPair == null || (currentValue = this.compute(pointPair)) <= entry.getValue()) continue;
            this.alert(ruleMinutes, entry.getValue(), currentValue);
        }
    }

    private Pair<JstatPoint, JstatPoint> getPointPair(LinkedList<JstatPoint> pointQueue, int n) {
        if (pointQueue == null || pointQueue.size() < 2) {
            return null;
        }
        int start = pointQueue.size() - (n + 1);
        if (start < 0) {
            start = 0;
        }
        return Pair.of((Object)pointQueue.get(start), (Object)pointQueue.getLast());
    }
}

