/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.redis.lettuce;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.redis.lettuce.CustomLettuceConnectionFactory;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

public class LettuceConnectionFactoryBeanPostProcessor
implements DestructionAwareBeanPostProcessor {
    private static final Map<LettuceConnectionFactory, LettuceConnectionFactory> LETTUCE_CONNECTION_FACTORY_BEAN_MAP = new HashMap<LettuceConnectionFactory, LettuceConnectionFactory>();

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (bean.getClass() == LettuceConnectionFactory.class) {
            LettuceConnectionFactory perfTestBean = LETTUCE_CONNECTION_FACTORY_BEAN_MAP.get(bean);
            if (perfTestBean == null) {
                return;
            }
            LETTUCE_CONNECTION_FACTORY_BEAN_MAP.remove(bean);
            try {
                perfTestBean.getClientResources().shutdown().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            perfTestBean.destroy();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean.getClass() == LettuceConnectionFactory.class) {
            LettuceConnectionFactory normalBean = (LettuceConnectionFactory)bean;
            LettuceConnectionFactory perfTestBean = this.getPerfTestBean(normalBean);
            perfTestBean.setDatabase(normalBean.getDatabase() + 1);
            LETTUCE_CONNECTION_FACTORY_BEAN_MAP.put(normalBean, perfTestBean);
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget((Object)normalBean);
            factory.addAdvice((Advice)new LettuceConnectionFactoryMethodInterceptor(normalBean, perfTestBean));
            return factory.getProxy();
        }
        return bean;
    }

    private LettuceConnectionFactory getPerfTestBean(LettuceConnectionFactory normalBean) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(normalBean.getHostName());
        config.setPort(normalBean.getPort());
        config.setPassword(RedisPassword.of((String)normalBean.getPassword()));
        config.setDatabase(normalBean.getDatabase());
        DefaultClientResources clientResources = DefaultClientResources.create();
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(8);
        poolConfig.setMinIdle(1);
        poolConfig.setMaxIdle(8);
        poolConfig.setMaxWaitMillis(100L);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTimeBetweenEvictionRunsMillis(180000L);
        LettucePoolingClientConfiguration lettucePoolingClientConfiguration = LettucePoolingClientConfiguration.builder().poolConfig(poolConfig).clientResources((ClientResources)clientResources).commandTimeout(normalBean.getClientConfiguration().getCommandTimeout()).shutdownTimeout(normalBean.getClientConfiguration().getShutdownTimeout()).build();
        CustomLettuceConnectionFactory perfTestBean = new CustomLettuceConnectionFactory(config, (LettuceClientConfiguration)lettucePoolingClientConfiguration);
        perfTestBean.setConvertPipelineAndTxResults(normalBean.getConvertPipelineAndTxResults());
        perfTestBean.setShareNativeConnection(normalBean.getShareNativeConnection());
        perfTestBean.setValidateConnection(normalBean.getValidateConnection());
        return perfTestBean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private static class LettuceConnectionFactoryMethodInterceptor
    implements MethodInterceptor {
        private final LettuceConnectionFactory normalBean;
        private final LettuceConnectionFactory perfTestBean;

        LettuceConnectionFactoryMethodInterceptor(LettuceConnectionFactory normalBean, LettuceConnectionFactory perfTestBean) {
            this.normalBean = normalBean;
            this.perfTestBean = perfTestBean;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("afterPropertiesSet")) {
                this.perfTestBean.afterPropertiesSet();
                return invocation.proceed();
            }
            if (!PerfTestUtils.isPerfTestEnv()) {
                return invocation.proceed();
            }
            return invocation.getMethod().invoke((Object)this.perfTestBean, invocation.getArguments());
        }
    }
}

