/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.sleuth;

import brave.ErrorParser;
import brave.Span;
import brave.Tracing;
import brave.TracingCustomizer;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.sampler.Sampler;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthHbasePlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthJestElasticSearchPlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthMongodbPlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthMybatisPlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthSpringDataLettucePlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.SleuthSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.sleuth.ttl.ThreadLocalCurrentTraceContext;
import com.alibaba.ttl.TransmittableThreadLocal;
import io.lettuce.core.RedisFuture;
import io.searchbox.client.JestClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.annotation.Aspect;
import org.elasticsearch.client.transport.TransportClient;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.sleuth.LocalServiceName;
import org.springframework.cloud.sleuth.SpanAdjuster;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.brave.ZipkinSpanHandler;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class SleuthAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Tracing.class})
    public static class SleuthTracingConfiguration {
        static final Comparator<SpanHandler> SPAN_HANDLER_COMPARATOR = (o1, o2) -> {
            if (o1 instanceof ZipkinSpanHandler) {
                if (o2 instanceof ZipkinSpanHandler) {
                    return 0;
                }
                return 1;
            }
            if (o2 instanceof ZipkinSpanHandler) {
                return -1;
            }
            return 0;
        };

        @Bean
        public Tracing tracing(@LocalServiceName String serviceName, Propagation.Factory factory, CurrentTraceContext currentTraceContext, Sampler sampler, ErrorParser errorParser, SleuthProperties sleuthProperties, @Nullable List<Reporter<zipkin2.Span>> spanReporters, @Nullable List<SpanAdjuster> spanAdjusters, @Nullable List<SpanHandler> spanHandlers, @Nullable List<TracingCustomizer> tracingCustomizers) {
            Tracing.Builder builder = Tracing.newBuilder().sampler(sampler).errorParser(errorParser).localServiceName(StringUtils.isEmpty((Object)serviceName) ? "default" : serviceName).propagationFactory(factory).currentTraceContext(currentTraceContext).spanReporter((Reporter)new CompositeReporter(spanAdjusters, spanReporters != null ? spanReporters : Collections.emptyList())).traceId128Bit(sleuthProperties.isTraceId128()).supportsJoin(sleuthProperties.isSupportsJoin()).propagationFactory(BaggagePropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY).add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)"_duibaServiceGroupKey"))).build());
            if (spanHandlers != null) {
                for (SpanHandler spanHandlerFactory : spanHandlers) {
                    builder.addSpanHandler(spanHandlerFactory);
                }
            }
            if (tracingCustomizers != null) {
                for (TracingCustomizer customizer : tracingCustomizers) {
                    customizer.customize(builder);
                }
            }
            this.reorderZipkinHandlersLast(builder);
            return builder.build();
        }

        private void reorderZipkinHandlersLast(Tracing.Builder builder) {
            ArrayList<SpanHandler> configuredSpanHandlers = new ArrayList<SpanHandler>(builder.spanHandlers());
            configuredSpanHandlers.sort(SPAN_HANDLER_COMPARATOR);
            builder.clearSpanHandlers();
            for (SpanHandler spanHandler : configuredSpanHandlers) {
                builder.addSpanHandler(spanHandler);
            }
        }

        private static final class CompositeReporter
        implements Reporter<zipkin2.Span> {
            private static final Log log = LogFactory.getLog(CompositeReporter.class);
            private final List<SpanAdjuster> spanAdjusters;
            private final Reporter<zipkin2.Span> spanReporter;

            private CompositeReporter(List<SpanAdjuster> spanAdjusters, List<Reporter<zipkin2.Span>> spanReporters) {
                Reporter<zipkin2.Span> reporter;
                this.spanAdjusters = spanAdjusters;
                if (spanReporters.size() == 1) {
                    reporter = spanReporters.get(0);
                } else {
                    Reporter<zipkin2.Span> reporter2;
                    reporter = reporter2;
                    super(spanReporters);
                }
                this.spanReporter = reporter;
            }

            public void report(zipkin2.Span span) {
                zipkin2.Span spanToAdjust = span;
                for (SpanAdjuster spanAdjuster : this.spanAdjusters) {
                    spanToAdjust = spanAdjuster.adjust(spanToAdjust);
                }
                this.spanReporter.report((Object)spanToAdjust);
            }

            public String toString() {
                return "CompositeReporter{spanAdjusters=" + this.spanAdjusters + ", spanReporters=" + this.spanReporter + '}';
            }

            private static final class ListReporter
            implements Reporter<zipkin2.Span> {
                private final List<Reporter<zipkin2.Span>> spanReporters;

                private ListReporter(List<Reporter<zipkin2.Span>> spanReporters) {
                    this.spanReporters = spanReporters;
                }

                public void report(zipkin2.Span span) {
                    for (Reporter<zipkin2.Span> spanReporter : this.spanReporters) {
                        try {
                            spanReporter.report((Object)span);
                        }
                        catch (Exception ex) {
                            log.warn((Object)("Exception occurred while trying to report the span " + span), (Throwable)ex);
                        }
                    }
                }

                public String toString() {
                    return "ListReporter{spanReporters=" + this.spanReporters + '}';
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransmittableThreadLocal.class})
    public static class SleuthTtlConfiguration {
        @Bean
        public CurrentTraceContext.Builder sleuthCurrentTraceContextBuilder() {
            return ThreadLocalCurrentTraceContext.newBuilder();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Connection.class, HTable.class, Span.class, Aspect.class})
    public static class SleuthHbaseConfiguration {
        @Bean
        public SleuthHbasePlugin sleuthHbasePlugin() {
            return new SleuthHbasePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JestClient.class, Span.class, Aspect.class})
    public static class SleuthJestElasticsearchConfiguration {
        @Bean
        public SleuthJestElasticSearchPlugin sleuthJestElasticSearchPlugin() {
            return new SleuthJestElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={TransportClient.class, ElasticsearchOperations.class, Span.class, Aspect.class})
    public static class SleuthElasticsearchConfiguration {
        @Bean
        public SleuthElasticSearchPlugin sleuthElasticSearchPlugin() {
            return new SleuthElasticSearchPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Span.class, Aspect.class, MongoOperations.class})
    public static class SleuthMongodbConfiguration {
        @Bean
        public SleuthMongodbPlugin sleuthMongodbPlugin() {
            return new SleuthMongodbPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, RedisFuture.class, Span.class, Aspect.class})
    public static class SleuthSpringDataLettuceAspectConfiguration {
        @Bean
        public SleuthSpringDataLettucePlugin sleuthSpringDataLettuceAspectPlugin() {
            return new SleuthSpringDataLettucePlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthSpringDataRedisAspectConfiguration {
        @Bean
        public SleuthSpringDataRedisPlugin sleuthSpringDataRedisAspectPlugin() {
            return new SleuthSpringDataRedisPlugin();
        }
    }

    @Configuration
    @ConditionalOnClass(value={RedisClient.class, Jedis.class, Span.class, Aspect.class})
    public static class SleuthRedisPluginConfiguration {
        @Bean
        public SleuthRedisPlugin sleuthRedisPlugin() {
            return new SleuthRedisPlugin();
        }
    }

    private static class SleuthMybatisBeanPostProcessor
    implements SpecifiedBeanPostProcessor<Object>,
    BeanFactoryAware {
        private BeanFactory beanFactory;
        private volatile SleuthMybatisPlugin sleuthMybatisPlugin;

        private SleuthMybatisBeanPostProcessor() {
        }

        private SleuthMybatisPlugin getSleuthMybatisPlugin() {
            if (this.sleuthMybatisPlugin == null) {
                this.sleuthMybatisPlugin = (SleuthMybatisPlugin)this.beanFactory.getBean(SleuthMybatisPlugin.class);
            }
            return this.sleuthMybatisPlugin;
        }

        public int getOrder() {
            return -1;
        }

        @Override
        public Class<Object> getBeanType() {
            return Object.class;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            SqlSessionFactory s = null;
            if (bean instanceof SqlSessionFactory) {
                s = (SqlSessionFactory)bean;
            }
            if (bean instanceof SqlSessionTemplate) {
                s = ((SqlSessionTemplate)bean).getSqlSessionFactory();
            }
            if (s == null) {
                return bean;
            }
            this.addInterceptor(s);
            return bean;
        }

        private void addInterceptor(SqlSessionFactory s) {
            boolean hasCatPlugin = false;
            if (!CollectionUtils.isEmpty((Collection)s.getConfiguration().getInterceptors())) {
                for (Interceptor plugin : s.getConfiguration().getInterceptors()) {
                    if (!(plugin instanceof SleuthMybatisPlugin)) continue;
                    hasCatPlugin = true;
                    break;
                }
            }
            if (!hasCatPlugin && this.getSleuthMybatisPlugin() != null) {
                s.getConfiguration().addInterceptor((Interceptor)this.getSleuthMybatisPlugin());
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }

    @Configuration
    @ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class, Span.class})
    public static class SleuthMyBatisPostProcessorConfiguration {
        @Bean
        public SleuthMybatisPlugin sleuthMybatisPlugin() {
            return new SleuthMybatisPlugin();
        }

        @Bean
        public static SpecifiedBeanPostProcessor sleuthMyBatisPostProcessorConfigurer() {
            return new SleuthMybatisBeanPostProcessor();
        }
    }
}

