package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RunEnvUtils;
import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringBootVersion;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;

import static cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataAutoConfiguration.*;

@Component
public class CommonDiscoveryMetadataRegister implements DiscoveryMetadataRegister {
    //服务器启动时间
    private static long serverStartUpTime;

    @Value("${"+ServiceGroupUtils.ENV_DUIBA_SERVICE_GROUP_KEY+":}")
    private String duibaServiceGroupKey;//当前服务器的多场景测试的场景ID
    @Value("${"+ZONE+":defaultZone}")
    private String zone;//当前服务器所在的可用区
    @Value("${"+ DUIBA_WARMUP_TIMEMILLIS +":300000}")
    private Integer duibaWarmUpTimeMillis;

    @Autowired
    private Environment environment;

    @Resource
    private SpringClientFactory ribbonSpringClientFactory;

    private volatile boolean contextStarted = false;

    @EventListener(MainContextRefreshedEvent.class)
    public void onMainContextRefreshed(){
        contextStarted = true;
    }

    /**
     * 获取服务启动时间，确保应用启动成功后只生成一次。
     * @return
     */
    private synchronized long getServerStartUpTime(){
        if(!contextStarted){
            return System.currentTimeMillis();
        }

        if(serverStartUpTime == 0){
            serverStartUpTime = System.currentTimeMillis();
        }
        return serverStartUpTime;
    }

    /**
     * 外部获取服务启动时间
     * 返回0 表示还未设置
     * @return
     */
    public static long getServerStartUpTimeOuternal() {
        return serverStartUpTime;
    }

    @Override
    public void registerMetadata(Map<String, String> metadata) {
        long serverStartUpTime = getServerStartUpTime();

        //metadata中放入服务器启动时间
        metadata.put(SERVER_START_UP_TIME_KEY, String.valueOf(serverStartUpTime));
        metadata.put(DUIBA_WARMUP_TIMEMILLIS, String.valueOf(duibaWarmUpTimeMillis));

        //metadata中放入服务器权重,默认100
        //TODO 这里有点小问题，如果有人改了权重，refresh之后权重会被重置回100,后期改掉,把100作为变量放在某处，允许改变
        metadata.put(WEIGHT_KEY, String.valueOf(100));

        boolean jarInJarMode = SpringBootUtils.isJarInJarMode();
        metadata.put(RUN_IN_SINGLE_JAR_MODE, jarInJarMode ? "true" : "false");
        metadata.put(SPRING_BOOT_VERSION, StringUtils.trimToEmpty(SpringBootVersion.getVersion()));
        metadata.put(DUIBA_BOOT_VERSION, StringUtils.trimToEmpty(DuibaBootVersion.getVersion()));
        metadata.put(RUN_IN_DOCKER, RunEnvUtils.isRunInDocker() ? "true" : "false");
        if (StringUtils.isNotBlank(duibaServiceGroupKey)) {
            metadata.put(DUIBA_SERVICE_GROUP_KEY, duibaServiceGroupKey);
        } else if (!RunEnvUtils.isRunInDocker()) {
            // 如果是本地启用的话，修改duibaServiceGroupKey为 _duibaServiceGroupKey=dev_ip_本机ip
            metadata.put(DUIBA_SERVICE_GROUP_KEY, ServiceGroupUtils.DUIBA_SERVICE_GROUP_IP_PREFIX + NetUtils.getLocalIp());
        }
        metadata.put(CONFIG_VERSION, StringUtils.trimToEmpty(environment.getProperty("config.client.version")));

        metadata.put(ZONE, StringUtils.trimToEmpty(zone));

        // 注入服务依赖
        metadata.put(DEPENDENTS_KEY, Joiner.on(",").join(ribbonSpringClientFactory.getContextNames()));
    }
}
