package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 方便本地开发的filter
 * <p>
 * 如果本地请求开发环境，将服务分组标识更新为本机的ip地址，方便流量打到本地启动的service服务
 *
 * @author guoyanfei
 */
@Slf4j
public class ServiceGroupFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;

        //开发环境使用HttpRequest的ip，作为服务分组id，以实现优先调用开发者本地服务的逻辑，以提升开发效率
        if (SpringEnvironmentUtils.isDevEnv()) {
            String ip = RequestTool.getIpAddr(req);
            if (ip.equals("127.0.0.1")) {
                ip = NetUtils.getLocalIp();
            }

            // sleuth中不存在服务分组标识，才会更新
            ServiceGroupUtils.setGroupKey(ServiceGroupUtils.DUIBA_SERVICE_GROUP_IP_PREFIX + ip);
        }

        chain.doFilter(request, response);
    }


    @Override
    public void destroy() {
        //do nothing
    }
}
