package cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob;

import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage;
import io.elasticjob.lite.event.type.JobExecutionEvent;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.MediaType;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-22 19:41
 * @descript: 缓存状态拦截: /monitor/cache/all 获取作业的监控数据
 * @version: 1.0
 */
@Slf4j
@ControllerEndpoint(id="monitor-elasticjob")
public class ElasticjobMonitorMvcEndpoint {

    @Autowired
    private ElasticjobMonitorManager elasticjobMonitorManager;

    @ResponseBody
    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    MediaType.APPLICATION_JSON_VALUE
            },
            value = "/{path}"
    )
    public Object invoke(@PathVariable String path, HttpServletRequest request) {
        if (path.equals("namespace")) {
            return elasticjobMonitorManager.getJobNamespace();
        }

        if (path.equals("trigger")) {

            String jobClassName = request.getParameter("key");
            String shardingItems = request.getParameter("shardingItems");
            if (StringUtils.isBlank(jobClassName) || StringUtils.isBlank(shardingItems)) {
                return Boolean.FALSE;
            }

            return elasticjobMonitorManager.trigger(jobClassName, Splitter.on(",").splitToList(shardingItems).stream().map(Integer::parseInt).collect(Collectors.toList()));
        }

        if (path.equals("consumeEvent")) {
            return buildTrackEvent();
        }

        return "";
    }

    private List<JobExecutionTrackEvent> buildTrackEvent() {

        boolean isPresent = ClassUtils.isPresent("io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage", null);
        if (!isPresent) {
            return Collections.emptyList();
        }

        List<JobExecutionEvent> events = JobEventCacheStorage.consumeEvent();
        List<JobExecutionTrackEvent> trackEvents = Lists.newArrayListWithCapacity(events.size());
        events.forEach(event -> {

            JobExecutionTrackEvent trackEvent = BeanUtils.copy(event, JobExecutionTrackEvent.class);
            trackEvent.setFailureCause(event.getFailureCause());
            String cron = elasticjobMonitorManager.getJobCron(event.getJobName());

            if(StringUtils.isBlank(cron)) {
                return;
            }

            try {

                CronExpression cronSequenceGenerator = new CronExpression(cron);
                Date nextTime = cronSequenceGenerator.getNextValidTimeAfter(trackEvent.getStartTime());
                trackEvent.setNextTime(nextTime);
            } catch (Exception e) {
                log.warn("解析任务的下次执行时间异常, jobName:{}", event.getJobName(), e);
            }

            trackEvents.add(trackEvent);

        });

        return trackEvents;
    }
}
