package cn.com.duibaboot.ext.autoconfigure.perftest.hbase;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.HierarchyMatch.byHierarchyMatch;
import static net.bytebuddy.matcher.ElementMatchers.any;

/**
 * 压测时给表换个namespace
 */
public class HbaseOperationsInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "org.springframework.data.hadoop.hbase.HbaseOperations";

    private static final String METHOD_INTERCEPTOR_CLASS = HbaseOperationsMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
        return byHierarchyMatch(new String[] { ENHANCE_CLASS });
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] { new InstanceMethodsInterceptPoint() {

            @Override
            public ElementMatcher<MethodDescription> getMethodsMatcher() {
                return any();
            }

            @Override
            public String getMethodsInterceptor() {
                return METHOD_INTERCEPTOR_CLASS;
            }

            @Override
            public boolean isOverrideArgs() {
                return true;
            }
        } };
    }
}
