package cn.com.duibaboot.ext.autoconfigure.perftest.httpclient;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;

public class PerfTestHttpAsyncClientBeanPostProcessor implements SpecifiedBeanPostProcessor<CloseableHttpAsyncClient> {

    @Override
    public Class<CloseableHttpAsyncClient> getBeanType() {
        return CloseableHttpAsyncClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(CloseableHttpAsyncClient bean, String beanName) throws BeansException {
        // 如果当前不是压测环境，直接返回bean
        if (!PerfTestUtils.isPerfTestEnv()) {
            return bean;
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget(bean);
        proxyFactory.addAdvice(new PerfTestHttpAsyncClientMethodInterceptor());
        return proxyFactory.getProxy();
    }

    @Override
    public int getOrder() {
        return 0;
    }

}
