package cn.com.duibaboot.ext.autoconfigure.dbexec;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by guoyanfei .
 * 2018/5/28 .
 */
@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties({ DuibaExtExecProperties.class })
public class ExecAutoConfiguration {

    @Bean
    public ExecMvcEndpoint execMvcEndpoint() {
        return new ExecMvcEndpoint();
    }

    @Bean
    @ConditionalOnProperty(prefix = "duiba.ext.exec", name = "asyncProfilerCommand")
    public AsyncProfilerEndpoint asyncProfilerEndpoint() {
        return new AsyncProfilerEndpoint();
    }

}
