package cn.com.duibaboot.ext.autoconfigure.grouping;

import cn.com.duibaboot.ext.autoconfigure.grouping.filter.ServiceGroupFilter;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.Ordered;

import javax.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * 多场景测试的支持
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Configuration
@ConditionalOnClass({ TransmittableThreadLocal.class })
@EnableAspectJAutoProxy(proxyTargetClass = true)
public class ServiceGroupAutoConfiguration {

    /**
     * 配置Filter，在处理请求之前先标识服务分组标记
     */
    @Configuration
    @ConditionalOnClass({ TransmittableThreadLocal.class })
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    static class ServiceGroupFilterConfigurationServlet {

        @Bean
        public ServiceGroupFilter serviceGroupFilter() {
            return new ServiceGroupFilter();
        }

        @Bean
        public FilterRegistrationBean<ServiceGroupFilter> serviceGroupFilterConfigurer(ServiceGroupFilter serviceGroupFilter) {
            FilterRegistrationBean<ServiceGroupFilter> registrationBean = new FilterRegistrationBean<>();
            registrationBean.setFilter(serviceGroupFilter);
            List<String> urlPatterns = new ArrayList<>();
            urlPatterns.add("/*");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            // 必须在sleuth的 TracingFilter之后，可以参考如下bean注入
            // org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration.traceWebFilter
            registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE + 6);
            return registrationBean;
        }

    }

}
