package cn.com.duibaboot.ext.autoconfigure.logger.logback;

import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import cn.com.duiba.boot.utils.NetUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * 在线程名后面附加sleuth分布式追踪的相关信息:tradeId,spanId,exportable
 */
public class DuibaThreadConverter extends ThreadConverter {

    private static final String TRACE_ID = "X-B3-TraceId";
    private static final String SPAN_ID = "X-B3-SpanId";
    private static final String EXPORTABLE = "X-Span-Export";

    @Override
    public String convert(ILoggingEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.convert(event));

        //在线程名后面附加sleuth分布式追踪的相关信息:tradeId,spanId,exportable
        //相当于把[%thread]  转为如下格式： [%thread,%X{X-B3-TraceId:-},%X{X-B3-SpanId:-},%X{X-Span-Export:-}]

        //一般没有跨线程时MDC里能取到，如果用了AsyncAppender, 由于跨线程了，所以MDC里取不到，需要到event.getMDCPropertyMap()里取得
        Map<String, String> mdcPropertyMap = event.getMDCPropertyMap();

        String traceId = null;
        String spanId = null;
        String exportable = null;
        if (mdcPropertyMap != null) {
            traceId = event.getMDCPropertyMap().getOrDefault(TRACE_ID, "");
            spanId = event.getMDCPropertyMap().getOrDefault(SPAN_ID, "");
            exportable = event.getMDCPropertyMap().getOrDefault(EXPORTABLE, "");
        }

        sb.append(",").append(StringUtils.trimToEmpty(traceId));
        sb.append(",").append(StringUtils.trimToEmpty(spanId));
        sb.append(",").append(StringUtils.trimToEmpty(exportable));
        sb.append(",").append(NetUtils.getLocalIp());

        return sb.toString();
    }
}
