package cn.com.duibaboot.ext.autoconfigure.monitor.rpc.endpoint;

import cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan.RpcConsumerScan;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 拉取某个服务RPC接口依赖 Endpoint
 */
@Endpoint(id = "rpc-consumer")
public class RpcConsumerEndpoint {

    private static final Logger LOGGER = LoggerFactory.getLogger(RpcConsumerEndpoint.class);

    /**
     * 获取单个服务rpc引入信息
     *
     * @param appName
     * @return
     */
    @ReadOperation
    public Map<String, Set<String>> invoke(@Selector String appName) {
        Map<String, Set<String>> allServerRpcMap = RpcConsumerScan.getRpcMonitorInfo();
        if (StringUtils.isBlank(appName) || "all".equals(appName)) {
            return allServerRpcMap;
        }
        // 如果path是无效的应用，亦返回空
        Map<String, Set<String>> serverRpcMap = new HashMap<>();
        serverRpcMap.put(appName, allServerRpcMap.get(appName));
        return serverRpcMap;
    }

}
