package cn.com.duibaboot.ext.autoconfigure.perftest.dubbo;

import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarkerHolder;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;

/**
 * dubbo服务端增加压测足迹
 * Created by guoyanfei .
 * 2022/2/21 .
 */
@Activate(group = { CommonConstants.PROVIDER_SIDE }, order = 0)
public class DubboPerfTestFootFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (PerfTestUtils.isPerfTestEnv()) {
            PerfTestFootMarker footMarker = PerfTestFootMarkerHolder.getPerfTestFootMarker();
            if (footMarker != null) {
                footMarker.markApp();
            }
        }
        return invoker.invoke(invocation);
    }
}
