/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.HbaseProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

public class ExtraHbaseImportBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private List<String> extraHbaseConnectionKeys = new ArrayList<String>();

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        for (String extraHbaseConnectionKey : this.extraHbaseConnectionKeys) {
            AbstractBeanDefinition extraHbaseConnectionDefinition = BeanDefinitionBuilder.genericBeanDefinition(HbaseConnectionFactoryBean.class).addConstructorArgValue((Object)extraHbaseConnectionKey).getBeanDefinition();
            registry.registerBeanDefinition(extraHbaseConnectionKey, (BeanDefinition)extraHbaseConnectionDefinition);
        }
    }

    public void setEnvironment(Environment environment) {
        String hbaseExtraIdPrefix = "duiba.hbase.extra.";
        String hbaseExtraIdPostfix = ".zk-quorum";
        String hbaseExtraIdPostfixOther = ".zkQuorum";
        LinkedHashMap props = SpringEnvironmentUtils.getFlatEnvironments((Environment)environment);
        props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(hbaseExtraIdPrefix) && (((String)e.getKey()).endsWith(hbaseExtraIdPostfix) || ((String)e.getKey()).endsWith(hbaseExtraIdPostfixOther))).map(e -> ((String)e.getKey()).split("\\.")[3]).forEach(s -> this.extraHbaseConnectionKeys.add((String)s));
    }

    public static class HbaseConnectionFactoryBean
    implements FactoryBean<Connection> {
        @Resource
        private HbaseProperties hbaseProperties;
        private String extraKey;

        public HbaseConnectionFactoryBean(String extraKey) {
            this.extraKey = extraKey;
        }

        public Connection getObject() throws Exception {
            Configuration configuration = this.hbaseProperties.getExtra().get(this.extraKey).getConfiguration();
            Connection connection = ConnectionFactory.createConnection((Configuration)configuration);
            return connection;
        }

        public Class<Connection> getObjectType() {
            return Connection.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

