/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="duiba.hbase")
public class HbaseProperties {
    private String zkQuorum;
    private Integer zkPort;
    private Integer rpcTimeout = 5000;
    private Integer operationTimeout = 10000;
    private Integer pause = 20;
    private Integer retriesNumber = 10;
    private Integer scannerTimeoutPeriod = 60000;
    private Properties properties;
    private Map<String, HbaseProperties> extra = new HashMap<String, HbaseProperties>();
    private Configuration configuration;

    public String getZkQuorum() {
        return this.zkQuorum;
    }

    public void setZkQuorum(String zkQuorum) {
        this.zkQuorum = zkQuorum;
    }

    public Integer getZkPort() {
        return this.zkPort;
    }

    public void setZkPort(Integer zkPort) {
        this.zkPort = zkPort;
    }

    public Integer getOperationTimeout() {
        return this.operationTimeout;
    }

    public void setOperationTimeout(Integer operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public Integer getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setRpcTimeout(Integer rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public Integer getPause() {
        return this.pause;
    }

    public void setPause(Integer pause) {
        this.pause = pause;
    }

    public Integer getRetriesNumber() {
        return this.retriesNumber;
    }

    public void setRetriesNumber(Integer retriesNumber) {
        this.retriesNumber = retriesNumber;
    }

    public Integer getScannerTimeoutPeriod() {
        return this.scannerTimeoutPeriod;
    }

    public void setScannerTimeoutPeriod(Integer scannerTimeoutPeriod) {
        this.scannerTimeoutPeriod = scannerTimeoutPeriod;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            Configuration conf = HBaseConfiguration.create();
            conf.set("hbase.zookeeper.quorum", this.getZkQuorum());
            if (this.getZkPort() != null) {
                conf.set("hbase.zookeeper.property.clientPort", this.getZkQuorum());
            }
            if (this.getRpcTimeout() != null) {
                conf.set("hbase.rpc.timeout", String.valueOf(this.getRpcTimeout()));
            }
            if (this.getOperationTimeout() != null) {
                conf.set("hbase.client.operation.timeout", String.valueOf(this.getOperationTimeout()));
                conf.set("hbase.client.meta.operation.timeout", String.valueOf(this.getOperationTimeout()));
            }
            if (this.getPause() != null) {
                conf.set("hbase.client.pause", String.valueOf(this.getPause()));
            }
            if (this.getScannerTimeoutPeriod() != null) {
                conf.set("hbase.client.scanner.timeout.period", String.valueOf(this.getScannerTimeoutPeriod()));
            }
            if (this.getProperties() != null) {
                this.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> conf.set(k.toString(), v.toString())));
            }
            this.configuration = conf;
        }
        return this.configuration;
    }

    public Map<String, HbaseProperties> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, HbaseProperties> extra) {
        this.extra = extra;
    }
}

