/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestEnvCondition;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestProperties;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestDataSourcePostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSource;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.PerfTestFootFilter;
import cn.com.duibaboot.ext.autoconfigure.perftest.filter.ReactivePerfTestFootFilter;
import cn.com.duibaboot.ext.autoconfigure.perftest.hazelcast.PerfTestEurekaHazelcastGroupKey;
import cn.com.duibaboot.ext.autoconfigure.perftest.httpclient.PerfTestHttpAsyncClientBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.httpclient.PerfTestHttpClientBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.redis.jedis.PerfTestRedisCachePlugin;
import cn.com.duibaboot.ext.autoconfigure.perftest.redis.jedis.PerfTestSpringDataRedisPlugin;
import cn.com.duibaboot.ext.autoconfigure.perftest.redis.lettuce.LettuceConnectionFactoryBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.perftest.redis.lettuce.LettuceConnectionFactoryMethodInterceptor;
import com.hazelcast.core.HazelcastInstance;
import com.netflix.appinfo.EurekaInstanceConfig;
import io.lettuce.core.RedisClient;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import redis.clients.jedis.Jedis;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableConfigurationProperties(value={PerfTestProperties.class})
@ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
public class DuibaPerftestAutoConfiguration {
    @PostConstruct
    public void init() {
        if ("true".equals(System.getProperty("duiba.noagent", "false"))) {
            throw new IllegalStateException("\u5f53\u5173\u95edjavaagent\u65f6\u7981\u6b62\u5f15\u5165spring-boot-starter-perftest\u5305, \u5982\u9700\u5f00\u542f\u538b\u6d4b\u652f\u6301\uff0c\u8bf7\u5f00\u542fjavaagent\uff0c\u5426\u5219\u538b\u6d4b\u65f6\u53ef\u80fd\u4f1a\u5bfc\u81f4\u5e72\u6270\u751f\u4ea7\u6570\u636e\u3002");
        }
    }

    @Bean
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    public DiscoveryMetadataRegister perftestSupportDiscoveryMetadataRegister() {
        return appMetadata -> appMetadata.put("isPerfTestSupportted", "1");
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={HttpAsyncClient.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestHttpAsyncClientBeanPostProcessorConfiguration {
        PerfTestHttpAsyncClientBeanPostProcessorConfiguration() {
        }

        @Bean
        public static SpecifiedBeanPostProcessor<CloseableHttpAsyncClient> perfTestHttpAsyncClientBeanPostProcessor() {
            return new PerfTestHttpAsyncClientBeanPostProcessor();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={HttpClient.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestHttpClientBeanPostProcessorConfiguration {
        PerfTestHttpClientBeanPostProcessorConfiguration() {
        }

        @Bean
        public static SpecifiedBeanPostProcessor<CloseableHttpClient> perfTestHttpClientBeanPostProcessor() {
            return new PerfTestHttpClientBeanPostProcessor();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={LettuceConnectionFactory.class, RedisClient.class, Aspect.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestSpringDataLettucePluginConfiguration {
        PerfTestSpringDataLettucePluginConfiguration() {
        }

        @Bean
        public static LettuceConnectionFactoryBeanPostProcessor newLettuceConnectionFactoryBeanPostProcessor() {
            return new LettuceConnectionFactoryBeanPostProcessor();
        }

        @Bean
        public LettuceConnectionFactoryMethodInterceptor newLettuceConnectionFactoryMethodInterceptor() {
            return new LettuceConnectionFactoryMethodInterceptor();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={JedisConnectionFactory.class, Jedis.class, Aspect.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestSpringDataRedisPluginConfiguration {
        PerfTestSpringDataRedisPluginConfiguration() {
        }

        @Bean
        public PerfTestSpringDataRedisPlugin newPerfTestSpringDataRedisPlugin() {
            return new PerfTestSpringDataRedisPlugin();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={cn.com.duiba.wolf.redis.RedisClient.class, Jedis.class, Aspect.class})
    @ConditionalOnBean(value={cn.com.duiba.wolf.redis.RedisClient.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestRedisCachePluginConfiguration {
        PerfTestRedisCachePluginConfiguration() {
        }

        @Bean
        public PerfTestRedisCachePlugin newPerfTestRedisCachePlugin() {
            return new PerfTestRedisCachePlugin();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={AbstractRoutingDataSource.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestDataSourceConfiguration {
        @Resource
        private ApplicationContext applicationContext;

        PerfTestDataSourceConfiguration() {
        }

        @EventListener(value={EnvironmentChangeEvent.class})
        public void onEnvironmentChange(EnvironmentChangeEvent event) {
            Map map = this.applicationContext.getBeansOfType(PerfTestRoutingDataSource.class);
            map.values().forEach(perfTestRoutingDataSource -> perfTestRoutingDataSource.onEnvironmentChange(event));
        }

        @Bean
        public static SpecifiedBeanPostProcessor<DataSource> perfTestDataSourcePostProcessor() {
            return new PerfTestDataSourcePostProcessor();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestFilterConfigurationReactive {
        PerfTestFilterConfigurationReactive() {
        }

        @Bean
        public ReactivePerfTestFootFilter reactivePerfTestFootFilter() {
            return new ReactivePerfTestFootFilter();
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestFilterConfigurationServlet {
        PerfTestFilterConfigurationServlet() {
        }

        @Bean
        public PerfTestFootFilter perfTestFootFilter() {
            return new PerfTestFootFilter();
        }

        @Bean
        public FilterRegistrationBean<PerfTestFootFilter> perfTestFootFilterConfigurer(PerfTestFootFilter perfTestFootFilter) {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)perfTestFootFilter);
            ArrayList<String> urlPatterns = new ArrayList<String>();
            urlPatterns.add("/*");
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(Integer.MAX_VALUE);
            return registrationBean;
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    @ConditionalOnClass(value={EurekaInstanceConfig.class, HazelcastInstance.class})
    static class PerfTestHazelcastEurekaInstanceConfigBeanPostProcessorConfiguration {
        PerfTestHazelcastEurekaInstanceConfigBeanPostProcessorConfiguration() {
        }

        @Bean
        public PerfTestEurekaHazelcastGroupKey perfTestEurekaHazelcastGroupKey() {
            String sceneId = PerfTestUtils.getSceneId();
            return new PerfTestEurekaHazelcastGroupKey(sceneId);
        }
    }

    @Configuration
    @Conditional(value={PerfTestEnvCondition.class})
    @ConditionalOnClass(value={EurekaInstanceConfig.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestDiscoveryMetadataRegisterConfiguration {
        PerfTestDiscoveryMetadataRegisterConfiguration() {
        }

        @Bean
        public DiscoveryMetadataRegister perftestDiscoveryMetadataRegister() {
            return appMetadata -> {
                appMetadata.put("duiba.new.perf.scene.id", PerfTestUtils.getSceneId());
                appMetadata.put("duiba.perf.scene.id", PerfTestUtils.getSceneId());
            };
        }
    }

    @Configuration
    @ConditionalOnBean(value={EtcdKVClientDelegate.class})
    @ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
    static class PerfTestFootMarkerConfiguration {
        PerfTestFootMarkerConfiguration() {
        }

        @Bean
        public PerfTestFootMarker perfTestFootMarker(EtcdKVClientDelegate etcdKVClientDelegate) {
            return new PerfTestFootMarker(etcdKVClientDelegate);
        }
    }
}

