/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.cloud.netflix.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.UnsupportedAppsHolder;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class PerfTestRibbonServerListFilter
implements RibbonServerListFilter {
    public List<Server> filter(List<Server> serverList, Object key) {
        if (serverList.isEmpty()) {
            return serverList;
        }
        for (Server s : serverList) {
            if (s instanceof DiscoveryEnabledServer) continue;
            return serverList;
        }
        String currentSceneId = PerfTestUtils.getSceneId();
        String targetAppName = null;
        ArrayList<Server> testList = new ArrayList<Server>(serverList.size());
        ArrayList<Server> prodList = new ArrayList<Server>(serverList.size());
        for (Server server : serverList) {
            String targetSceneId = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("duiba.new.perf.scene.id");
            if (StringUtils.isBlank(targetAppName)) {
                targetAppName = server.getMetaInfo().getAppName().toLowerCase();
            }
            if (this.sceneIdEquals(currentSceneId, targetSceneId)) {
                testList.add(server);
            }
            if (!StringUtils.isBlank((CharSequence)targetSceneId)) continue;
            prodList.add(server);
        }
        if (CollectionUtils.isNotEmpty(testList)) {
            return testList;
        }
        if (StringUtils.isNotBlank((CharSequence)currentSceneId) && !UnsupportedAppsHolder.isUnsupportedApp(targetAppName)) {
            throw new IllegalStateException("\u5f53\u524d\u673a\u5668\u662f\u538b\u6d4b\u673a\u5668\uff0c\u4f46\u662f\u627e\u4e0d\u5230\u76f8\u540c\u573a\u666fid\u7684\u538b\u6d4b\u673a\u5668\u3002\u5e76\u4e14\u76ee\u6807\u5e94\u7528\uff1a" + targetAppName + " \u4e0d\u5728\u3010unsupportApps\u3011\u4e2d\uff0c\u6d41\u7a0b\u65e0\u6cd5\u7ee7\u7eed\u5f80\u4e0b\u8c03\u7528");
        }
        return CollectionUtils.isNotEmpty(prodList) ? prodList : serverList;
    }

    private boolean sceneIdEquals(String currentSceneId, String targetSceneId) {
        if (currentSceneId == null || targetSceneId == null) {
            return false;
        }
        return currentSceneId.equals(targetSceneId);
    }
}

