/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import cn.com.duibaboot.ext.autoconfigure.perftest.datasource.PerfTestRoutingDataSource;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;

public class PerfTestRoutingDataSourceForHikari
extends PerfTestRoutingDataSource<HikariDataSource> {
    public PerfTestRoutingDataSourceForHikari(HikariDataSource originalDataSource, Environment environment, PerfTestFootMarker perfTestFootMarker) {
        super(originalDataSource, environment, perfTestFootMarker);
    }

    @Override
    protected String getJdbcUrl(HikariDataSource dataSource) {
        return dataSource.getJdbcUrl();
    }

    @Override
    protected HikariDataSource copyDataSource(String testUrl, HikariDataSource originalDataSource) {
        String driverClassName = originalDataSource.getDriverClassName();
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(StringUtils.isBlank((CharSequence)driverClassName) ? "com.mysql.cj.jdbc.Driver" : driverClassName);
        ds.setJdbcUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());
        ds.setLeakDetectionThreshold(originalDataSource.getLeakDetectionThreshold());
        ds.setMaximumPoolSize(originalDataSource.getMaximumPoolSize());
        ds.setMaxLifetime(originalDataSource.getMaxLifetime());
        ds.setMinimumIdle(0);
        ds.setIdleTimeout(30000L);
        ds.setValidationTimeout(originalDataSource.getValidationTimeout());
        ds.setConnectionTimeout(originalDataSource.getConnectionTimeout());
        ds.setPoolName(originalDataSource.getPoolName() + "_shade");
        ds.setConnectionInitSql(originalDataSource.getConnectionInitSql());
        return ds;
    }
}

