/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.log;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.filter.Filter;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestEnvCondition;
import cn.com.duibaboot.ext.autoconfigure.perftest.log.PerfTestLogDenyFilter;
import cn.com.duibaboot.ext.autoconfigure.perftest.log.PerfTestLogNameFilter;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
@Conditional(value={PerfTestEnvCondition.class})
@ConditionalOnResource(resources={"classpath:autoconfig/perftest.properties"})
public class PerfTestLogAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfTestLogAutoConfiguration.class);

    @Bean
    public PerfTestLogNameFilter perfTestLogNameFilter() {
        return new PerfTestLogNameFilter();
    }

    @Bean
    public PerfTestLogDenyFilter perfTestLogDenyFilter() {
        return new PerfTestLogDenyFilter();
    }

    @Bean
    public LogApplicationListener logApplicationListener() {
        return new LogApplicationListener();
    }

    private static class LogApplicationListener
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private static volatile boolean flag = true;
        private final Set<FileAppender> fileAppenders = Sets.newHashSet();
        private final Set<ConsoleAppender> consoleAppenders = Sets.newHashSet();
        private final Set<AsyncAppender> asyncAppenders = Sets.newHashSet();
        @Resource
        private PerfTestLogNameFilter perfTestLogNameFilter;
        @Resource
        private PerfTestLogDenyFilter perfTestLogDenyFilter;

        private LogApplicationListener() {
        }

        public int getOrder() {
            return 2147483627;
        }

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (!PerfTestUtils.isPerfTestEnv()) {
                return;
            }
            if (!flag) {
                return;
            }
            try {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                List loggers = loggerContext.getLoggerList();
                for (ch.qos.logback.classic.Logger logger : loggers) {
                    this.collectAppenders(logger);
                }
                for (FileAppender fileAppender : this.fileAppenders) {
                    if (fileAppender.getFile().contains("application")) {
                        fileAppender.addFilter((Filter)this.perfTestLogNameFilter);
                        continue;
                    }
                    fileAppender.addFilter((Filter)this.perfTestLogDenyFilter);
                }
                for (ConsoleAppender consoleAppender : this.consoleAppenders) {
                    consoleAppender.addFilter((Filter)this.perfTestLogNameFilter);
                }
                for (AsyncAppender asyncAppender : this.asyncAppenders) {
                    Iterator iterator = asyncAppender.iteratorForAppenders();
                    while (iterator.hasNext()) {
                        Appender childAsyncAppender = (Appender)iterator.next();
                        if (!(childAsyncAppender instanceof FileAppender)) continue;
                        FileAppender fileAppender = (FileAppender)childAsyncAppender;
                        if (fileAppender.getFile().contains("application")) {
                            asyncAppender.addFilter((Filter)this.perfTestLogNameFilter);
                            continue;
                        }
                        asyncAppender.addFilter((Filter)this.perfTestLogDenyFilter);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            flag = false;
        }

        private void collectAppenders(ch.qos.logback.classic.Logger log) {
            Iterator iter = log.iteratorForAppenders();
            while (iter.hasNext()) {
                Appender appender = (Appender)iter.next();
                if (appender instanceof FileAppender) {
                    this.fileAppenders.add((FileAppender)appender);
                }
                if (appender instanceof ConsoleAppender) {
                    this.consoleAppenders.add((ConsoleAppender)appender);
                }
                if (!(appender instanceof AsyncAppender)) continue;
                Iterator iterator = ((AsyncAppender)appender).iteratorForAppenders();
                while (iterator.hasNext()) {
                    Appender childAsyncAppender = (Appender)iterator.next();
                    if (!(childAsyncAppender instanceof FileAppender)) continue;
                    this.fileAppenders.add((FileAppender)childAsyncAppender);
                }
                this.asyncAppenders.add((AsyncAppender)appender);
            }
        }
    }
}

