package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

/**
 * 加入AOP，监控spring-data-elasticsearch执行耗时
 */
@Aspect
public class CatSpringDataElasticSearchPlugin {

	private static final String space = "Elasticsearch";

	/**
	 * 拦截ElasticsearchOperations类所有接口，记录执行耗时
	 * 
	 * @param joinPoint
	 * @return
	 * @throws Throwable
	 */
	@Around("execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*(..))")
	public Object springDataElasticSearchJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();

		return CatUtils.executeInCatTransaction(() -> joinPoint.proceed(), space, methodName);
	}

}
