package cn.com.duibaboot.ext.autoconfigure.data.redis;

import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class DuibaRedisCondition extends SpringBootCondition {

    @Override
    public ConditionOutcome getMatchOutcome(final ConditionContext conditionContext, final AnnotatedTypeMetadata annotatedTypeMetadata) {
        Environment environment = conditionContext.getEnvironment();
        return isRedisAutoConfigEnable(environment) ? ConditionOutcome.match() : ConditionOutcome.noMatch("Can't find redis configuration in environment.");
    }

    public static boolean isRedisAutoConfigEnable(Environment environment) {
        String redisHost = environment.getProperty(RedisProperties.REDIS_CONFIG_PREFIX + ".host");
        String redisClusterNodes = environment.getProperty(RedisProperties.REDIS_CONFIG_PREFIX + ".cluster.nodes");
        String redisSentinelMaster = environment.getProperty(RedisProperties.REDIS_CONFIG_PREFIX + ".sentinel.master");
        return StringUtils.isNotBlank(redisHost) || StringUtils.isNotBlank(redisClusterNodes) || StringUtils.isNotBlank(redisSentinelMaster);
    }
}
