/**
 * Copyright (c) 2022, duiba.com.cn All Rights Reserved.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.rpc;

import cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan.RpcConsumerScan;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * 描述: 应用引入并@Autowired @Resource RPC接口的引用情况
 *
 * @author guopengfei@duiba.com.cn
 * @version v1.0
 * @date 2022/2/24 15:57
 */
public class RpcConsumerBeanDefinitionRegistryPostProcessor implements ApplicationContextAware,  BeanDefinitionRegistryPostProcessor {

    private String applicationName;

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        applicationName = applicationContext.getEnvironment().getProperty("spring.application.name");
    }

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        // nothing
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        RpcConsumerScan.scanAndStore(beanFactory, applicationName);
    }
}
