package cn.com.duibaboot.ext.autoconfigure.perftest.dubbo;

import cn.com.duiba.boot.perftest.PerfTestConstant;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;

import java.util.List;

/**
 * dubbo注册的时候带上环境变量中的压测场景id
 * Created by guoyanfei .
 * 2022/2/18 .
 */
public class PerfTestRegistryFactoryWrapper implements RegistryFactory {

    private final RegistryFactory registryFactory;

    public PerfTestRegistryFactoryWrapper(RegistryFactory registryFactory) {
        this.registryFactory = registryFactory;
    }

    @Override
    public Registry getRegistry(URL url) {
        return new RegistryWrapper(this.registryFactory.getRegistry(url));
    }

    private static class RegistryWrapper implements Registry {

        private final Registry originRegistry;

        private URL appendProviderPerfTestKey(URL url) {
            String side = url.getParameter("side");
            if (CommonConstants.PROVIDER_SIDE.equals(side)) {
                url = url.addParameter(PerfTestConstant.IS_PERF_TEST_SUPPORTTED_KEY_OLD, true); // 兼容老逻辑
                if (PerfTestUtils.isPerfTestEnv()) {
                    // 注册dubbo接口时添加参数，表示本机器是压测的机器
                    url = url.addParameter(PerfTestConstant.PERF_TEST_SCENE_ID_DUBBO_KEY, PerfTestUtils.getSceneId());
                }
            }
            return url;
        }

        public RegistryWrapper(Registry originRegistry) {
            this.originRegistry = originRegistry;
        }

        @Override
        public URL getUrl() {
            return this.originRegistry.getUrl();
        }

        @Override
        public boolean isAvailable() {
            return this.originRegistry.isAvailable();
        }

        @Override
        public void destroy() {
            this.originRegistry.destroy();
        }

        @Override
        public void register(URL url) {
            this.originRegistry.register(this.appendProviderPerfTestKey(url));
        }

        @Override
        public void unregister(URL url) {
            this.originRegistry.unregister(this.appendProviderPerfTestKey(url));
        }

        @Override
        public void subscribe(URL url, NotifyListener listener) {
            this.originRegistry.subscribe(url, listener);
        }

        @Override
        public void unsubscribe(URL url, NotifyListener listener) {
            this.originRegistry.unsubscribe(url, listener);
        }

        @Override
        public List<URL> lookup(URL url) {
            return this.originRegistry.lookup(this.appendProviderPerfTestKey(url));
        }
    }

}
