package cn.com.duibaboot.ext.autoconfigure.perftest.elasticjob;

import com.google.common.base.Joiner;
import io.elasticjob.autoconfigure.ElasticJobAutoConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * elasticjob在压测容器上禁用
 * Created by guoyanfei .
 * 2022/3/11 .
 */
public final class ElasticJobPerfTestUtils {

    /**
     * 只在启动的时候执行，刷新配置的时候不可以执行，否则spring.autoconfigure.exclude可能会变更，然后触发刷新事件
     * @param environment
     * @param properties
     */
    public static void configProperties(ConfigurableEnvironment environment, Map<String, Object> properties) {
        try {
            Class.forName("io.elasticjob.autoconfigure.ZookeeperProperties");
        } catch (ClassNotFoundException e) {
            // 没有依赖ElasticJob，直接走
            return;
        }
        String property = "spring.autoconfigure.exclude";
        String excludeAutoConfigClasses = StringUtils.defaultString(environment.getProperty(property), null);

        List<String> excludeList = new ArrayList<>();
        if (StringUtils.isNotBlank(excludeAutoConfigClasses)) {
            excludeList.add(excludeAutoConfigClasses);
        }
        // 禁用 ElasticJobAutoConfiguration
        excludeList.add(ElasticJobAutoConfiguration.class.getName());
        excludeAutoConfigClasses = Joiner.on(",").skipNulls().join(excludeList);

        properties.put(property, excludeAutoConfigClasses);
    }
}
