package cn.com.duibaboot.ext.autoconfigure.perftest.filter;

import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import javax.annotation.Resource;

/**
 * 压测用的Filter,reactive版,当从request识别到是压测请求时，设置attribute。
 * <br/>
 * 识别到当前服务器cpu高时直接拒绝当前压测请求，如果5秒内拒绝了10个以上压测请求则直接熔断5秒。
 */
public class ReactivePerfTestFootFilter implements WebFilter {

    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (PerfTestUtils.isPerfTestEnv()) {
            perfTestFootMarker.markApp();
        }
        return chain.filter(exchange);
    }

}
