package cn.com.duibaboot.ext.autoconfigure.perftest.httpclient;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duiba.boot.perftest.PerfTestConstant;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

/**
 * httpAsyncClient请求的时候带上新版压测的压测标记
 * Created by guoyanfei .
 * 2022/3/8 .
 */
public class PerfTestHttpAsyncClientMethodInterceptor implements MethodInterceptor {

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!PerfTestUtils.isPerfTestEnv()) {
            return invocation.proceed();
        }

        if (!"execute".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        HttpRequest request = null;
        Object[] args = invocation.getArguments();
        for (Object arg : args) {
            if (arg instanceof HttpRequest) {
                request = (HttpRequest) arg;
                break;
            }
        }
        if (request == null) {
            return invocation.proceed();
        }

        Header[] headers = request.getHeaders(CustomRequestInterceptor.X_RPC);
        if (headers != null && headers.length > 0 && "true".equals(headers[0].getValue())) {
            // 已经标记为rpc请求的，不再处理header
            return invocation.proceed();
        }

        request.addHeader(PerfTestConstant.PERF_TEST_SCENE_ID_REQUEST_KEY, PerfTestUtils.getSceneId());

        return invocation.proceed();
    }

}
