package cn.com.duibaboot.ext.autoconfigure.perftest.redis.jedis;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.named;

/**
 * 压测时不让select方法生效，因为JedisPoolMethodInterceptor内部已经select过了，这里拦截掉避免dbIndex被改回去
 */
public class JedisConnectionInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "org.springframework.data.redis.connection.jedis.JedisConnection";

    private static final String JEDIS_METHOD_INTERCET_CLASS = JedisConnectionMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[0];
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] { new InstanceMethodsInterceptPoint() {

            @Override
            public ElementMatcher<MethodDescription> getMethodsMatcher() {
                return named("select");
            }

            @Override
            public String getMethodsInterceptor() {
                return JEDIS_METHOD_INTERCET_CLASS;
            }

            @Override
            public boolean isOverrideArgs() {
                return false;
            }
        } };
    }
}
