package cn.com.duibaboot.ext.autoconfigure.perftest.redis.jedis;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

/**
 * 拦截jedis操作，如果是发送消息(publish)则发送到特殊channel中，以防影响正常逻辑。
 */
public class JedisInterceptor implements InstanceMethodsAroundInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(JedisInterceptor.class);

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        //压测消息发送到特殊的名为PerfTest的channel中（因为redis的消息发送和订阅会无视dbIndex标志）
        if (method.getName().equals("publish") && PerfTestUtils.isPerfTestEnv()) {
            if (allArguments[0] instanceof byte[]) {
                allArguments[0] = "PerfTest".getBytes();
            } else if (allArguments[0] instanceof String) {
                allArguments[0] = "PerfTest";
            } else {
                LOGGER.warn("jedis' publish uses:{}, should not be here", allArguments[0].getClass().getName(), new IllegalStateException());
            }
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
