package cn.com.duibaboot.ext.autoconfigure.perftest.redis.jedis;

import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.PerfTestFootMarker;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Aspect
public class PerfTestRedisCachePlugin {

    private static final Logger LOGGER = LoggerFactory.getLogger(PerfTestRedisCachePlugin.class);

    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    private final Map<RedisClient, String> jedisHostMap = new ConcurrentHashMap<>();

    @Around("execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
    public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        RedisClient redisClient = (RedisClient) joinPoint.getTarget();
        String host = this.getHosts(redisClient);
        if (StringUtils.isNotBlank(host)) {
            perfTestFootMarker.markRedis(host);
        }
        return joinPoint.proceed();
    }

    private String getHosts(RedisClient redisClient) {
        String jedisHost = jedisHostMap.get(redisClient);
        if (StringUtils.isNotBlank(jedisHost)) {
            return jedisHost;
        }
        String newJedisHost = this.getNewJedisHost(redisClient);
        if (StringUtils.isBlank(newJedisHost)) {
            return null;
        }
        String jedisHostTemp = jedisHostMap.putIfAbsent(redisClient, newJedisHost);
        if (jedisHostTemp != null) {
            newJedisHost = jedisHostTemp;
        }
        return newJedisHost;
    }

    private String getNewJedisHost(RedisClient redisClient) {
        Jedis jedis = null;
        try {
            Class<?> redisClientClass = redisClient.getClass();
            Method method = redisClientClass.getDeclaredMethod("getResource");
            method.setAccessible(true);
            jedis = (Jedis) method.invoke(redisClient);
            if (jedis == null) {
                return null;
            }
            Client client = jedis.getClient();
            return client != null ? client.getHost() : null;
        } catch (Exception e) {
            LOGGER.error("getNewJedisHost error", e);
        } finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return null;
    }

}
