package cn.com.duibaboot.ext.autoconfigure.perftest.redis.lettuce;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;

/**
 * 检测LettuceConnectionFactory是不是在spring bean中定义的？如果不是则禁止启动（只有在bean中定义才能正确地启用对lettuce的压测功能）
 */
public class LettuceConnectionFactoryInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory";

    private static final String LETTUCE_METHOD_INTERCET_CLASS = LettuceConnectionFactoryMethodInterceptor.class.getName();

    @Override
    public ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return new ConstructorInterceptPoint[] { new ConstructorInterceptPoint() {

            @Override
            public ElementMatcher<MethodDescription> getConstructorMatcher() {
                return ElementMatchers.isConstructor();
            }

            @Override
            public String getConstructorInterceptor() {
                return LETTUCE_METHOD_INTERCET_CLASS;
            }
        } };
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[0];
    }
}
