package cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper;

import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ScheduledThreadPoolProperties;
import org.springframework.context.SmartLifecycle;

import java.util.concurrent.*;

public class ScheduledThreadPoolExecutorWrapper extends ThreadPoolExecutorWrapper implements ScheduledExecutorService, SmartLifecycle {

    public ScheduledThreadPoolExecutorWrapper(ScheduledThreadPoolProperties poolProperties) {
        super(ScheduledThreadPoolProperties.DEFAULT_SCHEDULED_BEAN_NAME, poolProperties);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return getScheduledThreadPoolExecutor().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    private ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return (ScheduledThreadPoolExecutor) getInnerThreadPoolExecutor();
    }

}
