/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.boot.cat.CatTools;
import cn.com.duibaboot.ext.autoconfigure.cat.context.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatUtils {
    private static final Logger logger = LoggerFactory.getLogger(CatUtils.class);

    private CatUtils() {
    }

    public static void completeTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            String messageId = tree.getMessageId();
            if (messageId == null) {
                messageId = Cat.createMessageId();
                tree.setMessageId(messageId);
            }
            CatUtils.printTransactionLog(transaction, tree);
        }
        transaction.complete();
    }

    private static void printTransactionLog(Transaction t, MessageTree tree) {
        if (logger.isDebugEnabled()) {
            logger.debug("mid:{},Cat_type:{},name:{},pid:{},rid:{},thread:{},created:{}", new Object[]{tree.getMessageId(), t.getType(), t.getName(), tree.getParentMessageId(), tree.getRootMessageId(), tree.getThreadName(), t.getTimestamp()});
        }
    }

    public static boolean isCatEnabled() {
        return CatUtils.isCatClassExists() && CatInstance.isEnable();
    }

    public static boolean isCatClassExists() {
        return CatTools.isCatClassExists();
    }

    public static <T> T executeInCatTransaction(Callback<T> callback, String type, String name) throws Throwable {
        if (!CatUtils.isCatEnabled()) {
            return callback.invoke();
        }
        Transaction transaction = Cat.newTransaction((String)type, (String)name);
        try {
            T result = callback.invoke();
            transaction.setStatus("0");
            T t = result;
            return t;
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
            transaction.setStatus(e);
            throw e;
        }
        finally {
            transaction.complete();
        }
    }

    public static void logAsyncCall(Cat.Context ctx) {
        if (CatUtils.isCatEnabled()) {
            try {
                MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
                String messageId = tree.getMessageId();
                if (messageId == null) {
                    messageId = Cat.getProducer().createMessageId();
                    tree.setMessageId(messageId);
                }
                String childId = Cat.getProducer().createRpcServerId("default");
                Cat.logEvent((String)"RemoteCall", (String)"async.callable", (String)"0", (String)childId);
                String root = tree.getRootMessageId();
                if (root == null) {
                    root = messageId;
                }
                ctx.addProperty("_catRootMessageId", root);
                ctx.addProperty("_catParentMessageId", messageId);
                ctx.addProperty("_catChildMessageId", childId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Transaction newCompletedTransaction(String type, String name, long startNanoTime) {
        try {
            if (CatUtils.isCatEnabled()) {
                Transaction t = Cat.getProducer().newTransaction(type, name);
                t.setDurationStart(startNanoTime);
                t.setStatus("0");
                t.addData("Thread", (Object)Thread.currentThread().getName());
                t.complete();
                return t;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static interface Callback<R> {
        public R invoke() throws Throwable;
    }
}

