/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import cn.com.duibaboot.ext.autoconfigure.data.hbase.ExtraHbaseImportBeanDefinitionRegistrar;
import cn.com.duibaboot.ext.autoconfigure.data.hbase.HbaseProperties;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={Connection.class})
@EnableConfigurationProperties(value={HbaseProperties.class})
@Import(value={ExtraHbaseImportBeanDefinitionRegistrar.class})
public class HbaseAutoConfiguration {
    @Resource
    private HbaseProperties hbaseProperties;

    @Bean(value={"connection"})
    @ConditionalOnProperty(name={"duiba.hbase.zk-quorum"}, matchIfMissing=false)
    @ConditionalOnMissingBean(value={Connection.class}, name={"connection"})
    public Connection connection() throws IOException {
        org.apache.hadoop.conf.Configuration configuration = this.hbaseProperties.getConfiguration();
        Connection connection = ConnectionFactory.createConnection((org.apache.hadoop.conf.Configuration)configuration);
        return connection;
    }
}

