/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.Hessian2SerializationRedisSerializer;
import cn.com.duibaboot.ext.autoconfigure.data.redis.LettuceConnectionFactoryBean;
import io.lettuce.core.RedisClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@ConditionalOnClass(value={RedisClient.class})
public class ExtraRedisTemplateImportBeanDefinitionRegistrar4Lettuce
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private List<String> extraRedisTemplateIdsPrefix = new ArrayList<String>();
    private static final String LETTUCE_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME = "destroy";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String extraRedisTemplateIdPrefix;
        String redisConnectionFactoryBeanId;
        Iterator<String> iterator = this.extraRedisTemplateIdsPrefix.iterator();
        while (iterator.hasNext() && !registry.containsBeanDefinition(redisConnectionFactoryBeanId = (extraRedisTemplateIdPrefix = iterator.next()) + "RedisConnectionFactory")) {
            AbstractBeanDefinition extraRedisConnectionFactoryDefinition = BeanDefinitionBuilder.genericBeanDefinition(LettuceConnectionFactoryBean.class).setDestroyMethodName(LETTUCE_CONNECTION_FACTORY_BEAN_DESTROY_METHOD_NAME).addConstructorArgValue((Object)extraRedisTemplateIdPrefix).getBeanDefinition();
            registry.registerBeanDefinition(redisConnectionFactoryBeanId, (BeanDefinition)extraRedisConnectionFactoryDefinition);
            String extRedisTemplateBeanName = extraRedisTemplateIdPrefix + "RedisTemplate";
            AbstractBeanDefinition extraRedisTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(RedisTemplate.class).addPropertyReference("connectionFactory", redisConnectionFactoryBeanId).addPropertyValue("defaultSerializer", (Object)new Hessian2SerializationRedisSerializer()).getBeanDefinition();
            registry.registerBeanDefinition(extRedisTemplateBeanName, (BeanDefinition)extraRedisTemplateDefinition);
            String extStringRedisTemplateBeanName = extraRedisTemplateIdPrefix + "StringRedisTemplate";
            AbstractBeanDefinition extraStringRedisTemplateDefinition = BeanDefinitionBuilder.genericBeanDefinition(StringRedisTemplate.class).addPropertyReference("connectionFactory", redisConnectionFactoryBeanId).getBeanDefinition();
            registry.registerBeanDefinition(extStringRedisTemplateBeanName, (BeanDefinition)extraStringRedisTemplateDefinition);
        }
    }

    public void setEnvironment(Environment environment) {
        String redisExtraIdPrefix = "duiba.redis.extra.";
        String redisExtraIdSuffix = ".host";
        String redisExtraIdSentinelSuffix = ".sentinel.master";
        String redisExtraIdClusterSuffix = ".cluster.nodes";
        LinkedHashMap props = SpringEnvironmentUtils.getFlatEnvironments((Environment)environment);
        for (Map.Entry entry : props.entrySet()) {
            if (!((String)entry.getKey()).startsWith(redisExtraIdPrefix)) continue;
            int prefixLength = redisExtraIdPrefix.length();
            if (((String)entry.getKey()).endsWith(redisExtraIdSuffix)) {
                this.extraRedisTemplateIdsPrefix.add(((String)entry.getKey()).substring(prefixLength, ((String)entry.getKey()).length() - redisExtraIdSuffix.length()));
                continue;
            }
            if (((String)entry.getKey()).endsWith(redisExtraIdSentinelSuffix)) {
                this.extraRedisTemplateIdsPrefix.add(((String)entry.getKey()).substring(prefixLength, ((String)entry.getKey()).length() - redisExtraIdSentinelSuffix.length()));
                continue;
            }
            if (!((String)entry.getKey()).endsWith(redisExtraIdClusterSuffix)) continue;
            this.extraRedisTemplateIdsPrefix.add(((String)entry.getKey()).substring(prefixLength, ((String)entry.getKey()).length() - redisExtraIdClusterSuffix.length()));
        }
    }
}

